/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.client.Client;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.containers.ContainerBuilderSettings;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.schematics.Blueprint;
import noppes.npcs.schematics.BlueprintUtil;
import noppes.npcs.schematics.Schematic;
import noppes.npcs.schematics.SchematicWrapper;
import noppes.npcs.util.BuilderData;

public class GuiBuilderSetting
extends GuiContainerNPCInterface
implements ICustomScrollListener,
ITextfieldListener {
    private static final Map<String, SchematicWrapper> baseFiles = new TreeMap<String, SchematicWrapper>();
    ContainerBuilderSettings container;
    private final ResourceLocation background = new ResourceLocation("customnpcs", "textures/gui/bgfilled.png");
    private final ResourceLocation inventory = new ResourceLocation("customnpcs", "textures/gui/baseinventory.png");
    private final ResourceLocation invRes = new ResourceLocation("textures/gui/container/inventory.png");
    private int maxRange = 10;
    private GuiCustomScroll schematics;
    private final BuilderData builder;
    private final Map<String, SchematicWrapper> files = new TreeMap<String, SchematicWrapper>();

    public GuiBuilderSetting(ContainerBuilderSettings cont) {
        super((EntityNPCInterface)null, (Container)cont);
        this.closeOnEsc = true;
        this.field_146999_f = 228;
        this.field_147000_g = 216;
        this.container = cont;
        this.builder = cont.builderData;
        for (String name : SchematicController.included) {
            InputStream stream = MinecraftServer.class.getResourceAsStream("/assets/customnpcs/schematics/" + name);
            if (stream == null) {
                File file = new File(SchematicController.getDir(), name);
                if (!file.exists()) continue;
                try {
                    stream = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    continue;
                }
            }
            try {
                NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)stream);
                stream.close();
                if (name.toLowerCase().endsWith(".blueprint")) {
                    if (compound.func_150296_c().isEmpty() || !compound.func_150297_b("size_x", 2) || !compound.func_150297_b("size_y", 2) || !compound.func_150297_b("size_z", 2) || !ClientProxy.playerData.game.op && compound.func_74765_d("size_x") * compound.func_74765_d("size_y") * compound.func_74765_d("size_z") > CustomNpcs.MaxBuilderBlocks) continue;
                    Blueprint bp = BlueprintUtil.readBlueprintFromNBT(compound);
                    if (bp != null) {
                        bp.setName(name);
                        baseFiles.put(name, new SchematicWrapper(bp));
                    }
                }
                if (compound.func_150296_c().isEmpty() || !compound.func_150297_b("Width", 2) || !compound.func_150297_b("Length", 2) || !compound.func_150297_b("Height", 2) || compound.func_74765_d("Width") * compound.func_74765_d("Length") * compound.func_74765_d("Height") > CustomNpcs.MaxBuilderBlocks) continue;
                Schematic schema = new Schematic(name);
                schema.load(compound);
                baseFiles.put(name, new SchematicWrapper(schema));
            }
            catch (IOException e) {
                LogWriter.error(e);
            }
        }
        this.files.putAll(baseFiles);
        File schematicDir = SchematicController.getDir();
        if (schematicDir.exists()) {
            for (File f : Objects.requireNonNull(schematicDir.listFiles())) {
                if (!f.isFile() || !f.getName().endsWith(".schematic")) continue;
                try {
                    NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(f.toPath(), new OpenOption[0]));
                    if (compound.func_150296_c().isEmpty() || !compound.func_150297_b("Width", 2) || !compound.func_150297_b("Length", 2) || !compound.func_150297_b("Height", 2) || !ClientProxy.playerData.game.op && compound.func_74765_d("Width") * compound.func_74765_d("Length") * compound.func_74765_d("Height") > CustomNpcs.MaxBuilderBlocks) continue;
                    Schematic schema = new Schematic(f.getName());
                    schema.load(compound);
                    this.files.put(f.getName(), new SchematicWrapper(schema));
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            }
        }
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 1: {
                if (this.builder == null) {
                    return;
                }
                this.builder.facing = button.getValue();
                break;
            }
            case 2: {
                if (this.builder == null) {
                    return;
                }
                this.builder.region[0] = button.getValue() + 1;
                break;
            }
            case 3: {
                if (this.builder == null) {
                    return;
                }
                this.builder.region[1] = button.getValue() + 1;
                break;
            }
            case 4: {
                if (this.builder == null) {
                    return;
                }
                this.builder.region[2] = button.getValue() + 1;
                break;
            }
            case 5: {
                if (this.builder == null) {
                    return;
                }
                this.builder.addAir = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
            case 6: {
                if (this.builder == null) {
                    return;
                }
                this.builder.replaceAir = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
            case 7: {
                if (this.builder == null) {
                    return;
                }
                this.builder.isSolid = ((GuiNpcCheckBox)button).isSelected();
            }
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.background);
        this.func_73729_b(0, 0, 0, 0, this.field_146999_f - 4, this.field_147000_g - 4);
        this.func_73729_b(this.field_146999_f - 4, 0, 252, 0, 4, this.field_147000_g - 4);
        this.func_73729_b(0, this.field_147000_g - 4, 0, 252, this.field_146999_f - 4, 4);
        this.func_73729_b(this.field_146999_f - 4, this.field_147000_g - 4, 252, 252, 4, 4);
        if (this.builder == null) {
            GlStateManager.func_179121_F();
            return;
        }
        int lineColor = new Color(-8355712).getRGB();
        if (this.builder.getType() < 3) {
            Gui.func_73734_a((int)140, (int)92, (int)200, (int)130, (int)new Color(-12566464).getRGB());
            Gui.func_73734_a((int)141, (int)93, (int)199, (int)129, (int)new Color(-10461088).getRGB());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(this.invRes);
            this.func_73729_b(140, 120, 73, 220, 16, 10);
            this.func_73730_a(4, 170, 132, lineColor);
            this.func_73728_b(170, 131, 212, lineColor);
            if (this.builder.getType() == 2) {
                this.func_73730_a(58, 112, 108, lineColor);
                this.func_73728_b(58, 108, 132, lineColor);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)7.0f, (float)135.0f, (float)0.0f);
            this.field_146297_k.func_110434_K().func_110577_a(this.inventory);
            this.func_73729_b(0, 0, 0, 0, 162, 76);
            this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
            GlStateManager.func_179109_b((float)0.0f, (float)-119.0f, (float)0.0f);
            for (int i = 1; i < 10; ++i) {
                this.func_73729_b(i / 6 * 54, ((i < 6 ? 0 : -5) + i - 1) * 24, 0, 0, 18, 18);
            }
            if (this.builder.getType() == 2) {
                this.func_73729_b(54, 96, 0, 0, 18, 18);
            }
            this.func_73730_a(-3, 106, -2, lineColor);
            this.func_73728_b(106, -13, 117, lineColor);
            GlStateManager.func_179121_F();
            float r = 1.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (this.builder.getType() == 1) {
                r = 0.0f;
                g = 1.0f;
                b = 1.0f;
            } else if (this.builder.getType() == 2) {
                g = 0.0f;
                b = 1.0f;
            }
            float size = (float)this.builder.region[2] + (float)(this.builder.region[0] + this.builder.region[1]) / 2.0f;
            float scale = size <= 0.0f ? 7.0f : 36.0f / size;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)1.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179109_b((float)(this.field_147003_i + 170), (float)(this.field_147009_r + 111), (float)100.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            RenderGlobal.func_189697_a((AxisAlignedBB)new AxisAlignedBB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.builder.facing == 0) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.01f);
            } else if (this.builder.facing == 2) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.1f);
            }
            RenderGlobal.func_189697_a((AxisAlignedBB)new AxisAlignedBB(-0.5 * (double)this.builder.region[0], -0.5 * (double)this.builder.region[1], -0.5 * (double)this.builder.region[2], 0.5 * (double)this.builder.region[0], 0.5 * (double)this.builder.region[1], 0.5 * (double)this.builder.region[2]), (float)r, (float)g, (float)b, (float)1.0f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        } else {
            this.func_73730_a(118, 223, 36, lineColor);
            this.func_73728_b(117, 3, 212, lineColor);
            GlStateManager.func_179121_F();
        }
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }

    protected void func_184098_a(@Nonnull Slot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        if (slotId >= 36) {
            int id = slotId - (this.builder.getType() == 2 ? 36 : 35);
            IGuiNpcTextField textField = this.getTextField(id);
            if (textField == null) {
                return;
            }
            if (slotIn.func_75211_c().func_190926_b()) {
                textField.setFullText("");
            } else {
                if (!this.builder.chances.containsKey(id)) {
                    this.builder.chances.put(id, 100);
                }
                textField.setFullText("" + this.builder.chances.get(id));
            }
        }
    }

    @Override
    public void func_73866_w_() {
        GuiNpcButton button;
        GuiNpcLabel label;
        GuiNpcTextField textField;
        int i;
        super.func_73866_w_();
        if (this.builder == null) {
            return;
        }
        this.maxRange = ClientProxy.playerData.game.op ? 100 : 10;
        int type = this.builder.getType();
        int y = this.field_147009_r + 4;
        if (this.builder.getID() > -1) {
            this.addLabel(new GuiNpcLabel(1, "ID:" + this.builder.getID(), this.field_147003_i + 120, y));
            y += 12;
        }
        if (type > 2) {
            if (this.schematics == null) {
                this.schematics = new GuiCustomScroll(this, 0);
                this.schematics.setSize(110, 197);
            }
            this.schematics.setList(new ArrayList<String>(this.files.keySet()));
            this.schematics.guiLeft = this.field_147003_i + 5;
            this.schematics.guiTop = this.field_147009_r + 14;
            if (!this.builder.schematicName.isEmpty()) {
                i = 0;
                Iterator<String> iterator = this.schematics.getList().iterator();
                while (iterator.hasNext()) {
                    String key;
                    String fName = key = iterator.next();
                    if (key.endsWith(".schematic")) {
                        fName = key.substring(0, key.lastIndexOf(".schematic"));
                    } else if (key.endsWith(".blueprint")) {
                        fName = key.substring(0, key.lastIndexOf(".blueprint"));
                    }
                    if (fName.equals(this.builder.schematicName)) {
                        this.schematics.setSelect(i);
                        break;
                    }
                    ++i;
                }
                if (i == this.schematics.getList().size()) {
                    this.schematics.setSelect(-1);
                }
            }
            this.addScroll(this.schematics);
            this.addLabel(new GuiNpcLabel(6, new TextComponentTranslation("gui.name", new Object[0]).func_150254_d() + ":", this.field_147003_i + 120, this.field_147009_r + 40));
            textField = new GuiNpcTextField(10, (GuiScreen)this, this.field_147003_i + 120, this.field_147009_r + 54, 99, 15, this.builder.schematicName);
            textField.setHoverText("scale.width", new Object[0]);
            this.addTextField(textField);
        }
        if (type < 3) {
            int i2;
            label = new GuiNpcLabel(0, new TextComponentTranslation("gui.help.block", new Object[0]).func_150254_d() + " [?]:", this.field_147003_i + 4, this.field_147009_r + 4);
            label.setHoverText("builder.hover.blocks." + type, new Object[0]);
            this.addLabel(label);
            label = new GuiNpcLabel(3, new TextComponentTranslation("gui.area", new Object[0]).func_150254_d() + " [?]:", this.field_147003_i + 120, y);
            label.setHoverText("builder.hover.type." + type, new Object[0]);
            this.addLabel(label);
            y += 12;
            for (i = 0; i < 3; ++i) {
                textField = new GuiNpcTextField(i + 10, (GuiScreen)this, this.field_147003_i + 120 + i * 34, y, 30, 15, "" + this.builder.region[i]);
                textField.setMinMaxDefault(1L, this.maxRange, this.builder.region[i]);
                if (i == 0) {
                    textField.setHoverText("scale.width", new Object[0]);
                } else if (i == 1) {
                    textField.setHoverText("scale.depth", new Object[0]);
                } else {
                    textField.setHoverText("schematic.height", new Object[0]);
                }
                this.addTextField(textField);
            }
            button = new GuiButtonBiDirectional(1, this.field_147003_i + 120, y += 18, 99, 20, new String[]{"builder.fasing.0", "builder.fasing.1", "builder.fasing.2"}, this.builder.facing);
            button.setHoverText("builder.hover.fasing", new Object[0]);
            this.addButton(button);
            double t = 0.0;
            double j = 0.0;
            for (int i3 = 1; i3 < 10; ++i3) {
                if (!this.builder.chances.containsKey(i3)) continue;
                t += (double)this.builder.chances.get(i3).intValue();
                j += 1.0;
            }
            if (this.builder.addAir) {
                t += t / j;
            }
            double[] vs = new double[10];
            for (i2 = 1; i2 < 10; ++i2) {
                if (this.getTextField(i2) == null || !this.getTextField(i2).isHovered()) continue;
                double c = 0.0;
                if (this.builder.chances.containsKey(i2)) {
                    c = type == 0 ? (double)this.builder.chances.get(i2).intValue() / 100.0 : (double)this.builder.chances.get(i2).intValue() / t;
                }
                vs[i2] = (double)Math.round(c * 1000.0) / 10.0;
                return;
            }
            for (i2 = 1; i2 < 10; ++i2) {
                textField = new GuiNpcTextField(i2, (GuiScreen)this, this.field_147003_i + 28 + i2 / 6 * 54, this.field_147009_r + 17 + ((i2 < 6 ? 0 : -5) + i2 - 1) * 24, 28, 15, "" + (this.builder.chances.containsKey(i2) ? (Serializable)this.builder.chances.get(i2) : ""));
                textField.setMinMaxDefault(1L, 100L, this.builder.chances.getOrDefault(i2, 100).intValue());
                textField.setHoverText("builder.hover.chance." + type, "" + vs[i2]);
                this.addTextField(textField);
            }
        } else {
            label = new GuiNpcLabel(5, new TextComponentTranslation("gui.file.list", new Object[0]).func_150254_d() + " [?]:", this.field_147003_i + 4, this.field_147009_r + 4);
            label.setHoverText("builder.hover.list", "" + this.maxRange);
            this.addLabel(label);
        }
        if (type < 4) {
            button = new GuiNpcCheckBox(5, this.field_147003_i + 120, y + 22, 99, 15, "tile.air.name", null, this.builder.addAir);
            button.setHoverText("schematic" + (type == 3 ? ".schem" : "") + ".air", new Object[0]);
            this.addButton(button);
            if (type == 2 || type == 3) {
                button = new GuiNpcCheckBox(6, this.field_147003_i + 172 + (type == 3 ? -52 : 0), this.field_147009_r + 145 + (type == 3 ? -60 : 0), 70, 15, "drop.type.all", null, this.builder.replaceAir);
                button.setHoverText("schematic" + (type == 3 ? ".schem" : "") + ".replace", new Object[0]);
                this.addButton(button);
            }
            if (type == 3) {
                button = new GuiNpcCheckBox(7, this.field_147003_i + 120, this.field_147009_r + 100, 70, 15, "gui.solid", null, this.builder.isSolid);
                button.setHoverText("schematic.schem.solid", new Object[0]);
                this.addButton(button);
            }
        }
        if (type == 2) {
            label = new GuiNpcLabel(4, "_[?]_", this.field_147003_i + 88, this.field_147009_r + 116);
            label.setHoverText("builder.hover.main.block", new Object[0]);
            this.addLabel(label);
        }
    }

    @Override
    public void save() {
        if (this.builder == null || this.container == null) {
            return;
        }
        this.container.save();
        Client.sendData(EnumPacketServer.BuilderSetting, this.builder.getNbt());
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        IGuiNpcTextField textField;
        this.builder.schematicName = scroll.getSelected();
        if (this.builder.schematicName.endsWith(".schematic")) {
            this.builder.schematicName = this.builder.schematicName.substring(0, this.builder.schematicName.lastIndexOf(".schematic"));
        } else if (this.builder.schematicName.endsWith(".blueprint")) {
            this.builder.schematicName = this.builder.schematicName.substring(0, this.builder.schematicName.lastIndexOf(".blueprint"));
        }
        SchematicWrapper schema = SchematicController.Instance.getSchema(this.builder.schematicName + ".schematic");
        if (schema != null) {
            this.builder.region[0] = schema.schema.getLength();
            this.builder.region[1] = schema.schema.getWidth();
            this.builder.region[2] = schema.schema.getHeight();
        }
        if ((textField = this.getTextField(10)) != null) {
            textField.setFullText(this.builder.schematicName);
        }
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (this.builder == null) {
            return;
        }
        if (textField.getID() < 10) {
            if (textField.getFullText().isEmpty()) {
                return;
            }
            if (this.builder.inv.func_70301_a(textField.getID()).func_190926_b()) {
                textField.setFullText("");
                return;
            }
            this.builder.chances.put(textField.getID(), textField.getInteger());
            return;
        }
        if (this.builder.getType() == 3 || this.builder.getType() == 4) {
            if (textField.getID() == 10) {
                this.builder.schematicName = textField.getFullText();
                this.func_73866_w_();
            }
        } else {
            int pos = textField.getID() - 10;
            int value = textField.getInteger();
            if (value > this.maxRange) {
                value = this.maxRange;
            }
            if (value <= 0) {
                value = 1;
            }
            this.builder.region[pos] = value;
        }
    }
}

